
<?php $__env->startPush('style'); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('main'); ?>
    
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <section class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Product Stock</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Project Add</li>
                    </ol>
                </div>
            </div>
        </section><!-- /.container-fluid -->
        
        <?php if(session('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>
        
    </section>
    
    <!-- Main content -->
    <section class="content">
        <div class="card">
            <div class="card-header border-0">
                <h3 class="card-title">Products</h3>
                <div class="card-tools">
                    <a href="#" class="btn btn-tool btn-sm">
                        <i class="fas fa-download"></i>
                    </a>
                    <a href="#" class="btn btn-tool btn-sm">
                        <i class="fas fa-bars"></i>
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-3">
                        <div class="info-box">
                            <span class="info-box-icon bg-success"><i class="fas fa-box"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">NEW PHONES</span>
                                <span class="info-box-number">Stock:
                                    <?php echo e($totalNewStock); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="info-box">
                            <span class="info-box-icon bg-warning"><i class="fas fa-box-open"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">OLD PHONES</span>
                                <span class="info-box-number">Stock:
                                    <?php echo e($totalOldStock); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="info-box">
                            <span class="info-box-icon bg-info"><i class="fas fa-cubes"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">TOTAL STOCK</span>
                                <span class="info-box-number"><?php echo e($totalStock); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="info-box">
                            <span class="info-box-icon bg-info"><i class="fas fa-cubes"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">TOTAL STOCK PRICE</span>
                                <span class="info-box-number"><?php echo e($all_settings->currency); ?> <?php echo e($totalCost); ?></span>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Product Stock</h3>
                    </div>
                    <div class="card-body">
                        <table id="data_table" class="table table-bordered table-striped">
                            <thead>
                                <th>#</th>
                                <th>Customer Info</th>
                                <th>Brand/Tppe</th>
                                <th>Model/Item</th>
                                <th>IMEI/SN</th>
                                <th>Condition</th>
                                <th>Stock</th>
                                <th>Color</th>
                                <th>GB</th>
                                <th>Buy Price</th>
                                <th>Last Updated</th>
                                <th>Action</th> <!-- Added Action column -->
                                </tr>
                            </thead>
                            <tbody>

                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($product->id); ?></td>
                                        <td>
                                            <?php if($product->customer): ?>
                                                Name:- <?php echo e($product->customer ? $product->customer->name : ''); ?>,
                                                Number:- <?php echo e($product->customer ? $product->customer->number : ''); ?>,
                                                cpr:- <?php echo e($product->customer ? $product->customer->cpr : ''); ?>,
                                                address:- <?php echo e($product->customer ? $product->customer->address : ''); ?>

                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($product->brand); ?> <?php echo e($product->type); ?></td>
<td><?php echo e($product->model); ?> <?php echo e($product->name); ?></td>
<td><?php echo e($product->imei_or_sn); ?></td>
<td><?php echo e($product->condition); ?></td>
<td><?php echo e($product->stock); ?></td>
<td><?php echo e($product->color); ?></td>
<td><?php echo e($product->gb); ?></td>
<td><?php echo e($all_settings->currency); ?> <?php echo e($product->buy_price); ?></td>
<td><?php echo e($product->updated_at); ?></td>
                                        <td>
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-info">Action</button>
                                                <button type="button"
                                                    class="btn btn-info dropdown-toggle dropdown-hover dropdown-icon"
                                                    data-toggle="dropdown" aria-expanded="false">
                                                    <span class="sr-only">Toggle Dropdown</span>
                                                </button>
                                                <div class="dropdown-menu" role="menu">
                                                    <a class="dropdown-item"
                                                        href="<?php echo e(route('product.edit', $product->id)); ?>">Edit</a>
                                                    <a class="dropdown-item"
                                                        href="<?php echo e(route('product.print', $product->id)); ?>"
                                                        target="_blank">Print Receipt</a>
                                                    <form action="<?php echo e(route('product.destroy', $product->id)); ?>"
                                                        method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="dropdown-item text-danger"
                                                            onclick="return confirm('Are you sure you want to delete this product?');">Delete</button>
                                                    </form>
                                                </div>

                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>#</th>
                                    <th>Customer Info</th>
                                    <th>Brand</th>
                                    <th>Model</th>
                                    <th>IMEI/SN</th>
                                    <th>Condition</th>
                                    <th>Stock</th>
                                    <th>Color</th>
                                    <th>GB</th>
                                    <th>Buy Price</th>
                                    <th>Last Updated</th>
                                    <th>Action</th> <!-- Added Action column -->
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(function() {
            $("#data_table").DataTable({
                "responsive": true,
                "lengthChange": true,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

        });
        $(document).ready(function() {});
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\pos v24.4\resources\views/product/stock.blade.php ENDPATH**/ ?>